<?php require_once "../includes/header.php"; ?>

<?php 
if (!isset($_SESSION['admin_id'])) {
    echo "<script> window.location.href = '".ADMINAUTH."' </script>";
    exit();
}

$admins = getAdmins();
$currentAdminId = $_SESSION['admin_id'];
$i = 0;
?>

<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">ئەدمین</h1>
        <ol class="breadcrumb mb-4 d-flex justify-content-between align-items-center">
            <li class="breadcrumb-item active">ئەدمین</li>
            <a href="add-admin.php" class="btn btn-primary">زێدەکرنا ئەدمینەکی</a>
        </ol>

        <div class="row">
            <?php if (!empty($admins)): ?>
                <?php foreach ($admins as $admin): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card shadow-sm border-0 h-100">
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($admin['full_name']) ?></h5>
                                <p class="mb-1"><strong>Username:</strong> <?= htmlspecialchars($admin['username']) ?></p>
                                <p class="mb-1"><strong>Email:</strong> <?= htmlspecialchars($admin['email']) ?></p>
                                <p class="mb-1"><strong>Phone:</strong> <?= htmlspecialchars($admin['phone']) ?></p>
                                <p class="mb-0 text-muted"><small>Joined: <?= date('Y-m-d H:i', strtotime($admin['created_at'])) ?></small></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="alert alert-warning">No admins found.</div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php require_once "../includes/footer.php"; ?>
