<?php require_once "../includes/header.php";
require_once "../../functions/database.php";

if (!isset($_SESSION['admin_id'])) {
    echo "<script> window.location.href = '" . ADMINAUTH . "' </script>";
    exit();
}

$id = $_SESSION['admin_id'];
$admin = getAdmin($id);
$adminAvatarsPath = ADMINASSETS . "images/";
$adminAvatar = $adminAvatarsPath . $admin['image'];
?>

<style>
.card { box-shadow: 0 1px 3px rgba(0,0,0,.1), 0 1px 2px rgba(0,0,0,.06); border-radius: .25rem; }
.card-body { padding: 1rem; }
.gutters-sm>.col { padding-right: 8px; padding-left: 8px; }
.bg-gray-300 { background-color: #e2e8f0; }
.shadow-none { box-shadow: none!important; }
</style>

<div class="container">
  <div class="main-body">
    <nav aria-label="breadcrumb" class="main-breadcrumb mt-4">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
        <li class="breadcrumb-item">Admin</li>
        <li class="breadcrumb-item active">Admin Profile</li>
      </ol>
    </nav>

    <div class="row gutters-sm">
      <div class="col-md-4 mb-3">
        <div class="card">
          <div class="card-body text-center">
            <img src="<?= $adminAvatar ?>" class="rounded-circle" width="100" alt="Avatar">
            <div class="mt-3">
              <h4><?= $admin['full_name'] ?></h4>
              <p class="text-muted"><?= $admin['address'] ?? 'N/A' ?></p>
              <p class="bg-info text-white px-2 py-1 rounded">Joined: <?= date('d M Y', strtotime($admin['created_at'])) ?></p>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-8">
        <div class="card mb-3">
          <div class="card-body">
            <div class="row mb-2"><div class="col-sm-3">Full Name</div><div class="col-sm-9 text-secondary"><?= $admin['full_name'] ?></div></div>
            <div class="row mb-2"><div class="col-sm-3">Email</div><div class="col-sm-9 text-secondary"><?= $admin['email'] ?></div></div>
            <div class="row mb-2"><div class="col-sm-3">Phone</div><div class="col-sm-9 text-secondary"><?= $admin['phone'] ?></div></div>
            <div class="row mb-4"><div class="col-sm-3">Address</div><div class="col-sm-9 text-secondary"><?= $admin['address'] ?></div></div>
            <div class="row">
              <div class="col-sm-6 mb-2">
                <button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#editProfileModal">Edit Profile</button>
              </div>
              <div class="col-sm-6">
                <button class="btn btn-warning w-100 text-white" data-bs-toggle="modal" data-bs-target="#changePasswordModal">Change Password</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Edit Profile Modal -->
<div class="modal fade" id="editProfileModal" tabindex="-1">
  <div class="modal-dialog">
    <form id="editProfileForm" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Profile</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="admin_id" value="<?= $id ?>">
        <div class="mb-3"><label>Full Name</label><input type="text" class="form-control" name="full_name" value="<?= $admin['full_name'] ?>" required></div>
        <div class="mb-3"><label>Email</label><input type="email" class="form-control" name="email" value="<?= $admin['email'] ?>" required></div>
        <div class="mb-3"><label>Phone</label><input type="text" class="form-control" name="phone" value="<?= $admin['phone'] ?>" required></div>
        <div class="mb-3"><label>Address</label><input type="text" class="form-control" name="address" value="<?= $admin['address'] ?>" required></div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Save Changes</button>
      </div>
    </form>
  </div>
</div>

<!-- Change Password Modal -->
<div class="modal fade" id="changePasswordModal" tabindex="-1">
  <div class="modal-dialog">
    <form id="changePasswordForm" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Change Password</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="admin_id" value="<?= $id ?>">
        <div class="mb-3"><label>Current Password</label><input type="password" class="form-control" name="current_password" required></div>
        <div class="mb-3"><label>New Password</label><input type="password" class="form-control" name="new_password" required></div>
        <div class="mb-3"><label>Confirm Password</label><input type="password" class="form-control" name="confirm_password" required></div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-warning">Update Password</button>
      </div>
    </form>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
$(function() {
  $('#editProfileForm').submit(function(e) {
    e.preventDefault();
    $.post('update_profile.php', $(this).serialize(), function(res) {
      alert(res.message);
      if (res.status === 'success') location.reload();
    }, 'json');
  });

  $('#changePasswordForm').submit(function(e) {
    e.preventDefault();
    const formData = $(this).serializeArray();
    const pwd1 = formData.find(f => f.name === 'new_password').value;
    const pwd2 = formData.find(f => f.name === 'confirm_password').value;
    if (pwd1 !== pwd2) return alert('Passwords do not match');
    $.post('change_password.php', $(this).serialize(), function(res) {
      alert(res.message);
      if (res.status === 'success') $('#changePasswordModal').modal('hide');
    }, 'json');
  });
});
</script>

<?php require_once "../includes/footer.php"; ?>
