<?php require_once "../includes/header.php"?>
<?php
require_once "../../functions/database.php";

$success = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $message = trim($_POST['message'] ?? '');

    if (!$name) $errors['name'] = "Name is required.";
    if (!$phone) $errors['phone'] = "Phone is required.";
    if (!$message) $errors['message'] = "Message is required.";

    if (empty($errors)) {
        $stmt = $pdo->prepare("INSERT INTO contacts (name, phone, message) VALUES (:name, :phone, :message)");
        $stmt->execute([
            ':name' => $name,
            ':phone' => $phone,
            ':message' => $message
        ]);
        $success = "Contact has been saved";
    }
}
?>


<div class="container mt-5 pt-5" style="margin-top: 120px;">
    <h2>Contacts</h2>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <form action="" method="POST" class="mt-4">
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($_POST['name'] ?? '') ?>">
            <?php if (isset($errors['name'])): ?><small class="text-danger"><?= $errors['name'] ?></small><?php endif; ?>
        </div>

        <div class="form-group">
            <label>Phone</label>
            <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>">
            <?php if (isset($errors['phone'])): ?><small class="text-danger"><?= $errors['phone'] ?></small><?php endif; ?>
        </div>

        <div class="form-group">
            <label>Message</label>
            <textarea name="message" class="form-control" rows="4"><?= htmlspecialchars($_POST['message'] ?? '') ?></textarea>
            <?php if (isset($errors['message'])): ?><small class="text-danger"><?= $errors['message'] ?></small><?php endif; ?>
        </div>

        <button type="submit" class="btn btn-primary">Send</button>
    </form>
</div>

<?php require_once "../includes/footer.php"?>