<?php require_once "../includes/header.php"?>
<?php
require_once "../../functions/database.php";


// Fetch all contacts
$stmt = $pdo->query("SELECT id, name, phone, message, created_at FROM contacts ORDER BY created_at DESC");
$contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-5 pt-5">
    <h2 class="mb-4">Contacts Diary</h2>

    <?php if (empty($contacts)): ?>
        <div class="alert alert-info">No contacts found.</div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($contacts as $contact): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="card-title mb-1"><?= htmlspecialchars($contact['name']) ?></h5>
                            <p class="text-muted mb-2"><strong>Phone:</strong> <?= htmlspecialchars($contact['phone']) ?></p>
                            <p class="card-text"><?= nl2br(htmlspecialchars(mb_strimwidth($contact['message'], 0, 100, '...'))) ?></p>
                        </div>
                        <div class="card-footer text-muted small">
                            <?= date('Y-m-d H:i', strtotime($contact['created_at'])) ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php require_once "../includes/footer.php"?>