<?php
// 1. helpers.php is inside admin-panel/helpers → go up one (..) from includes to admin-panel
require_once __DIR__ . '/../helpers/helpers.php';

// 2. database.php is inside htdocs/functions → go up two (../../) from includes to htdocs, then into functions
require_once __DIR__ . '/../../functions/database.php';

// 3. file_helpers.php same folder as database.php
require_once __DIR__ . '/../../functions/file_helpers.php';



if (!isset($_SESSION['admin_id'])) {
    header("Location: " . ADMINAUTH . "login.php");
    exit;
} else {
    $id = $_SESSION['admin_id'];
    $admin = getAdmin($id);
}
?>

<!DOCTYPE html>
<html lang="ku">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>داشبۆرد</title>
<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.6/css/dataTables.dataTables.min.css" />
    <link rel="stylesheet" href="<?php echo ADMINURL ?>assets/css/styles.css" />
    <link rel="stylesheet" href="<?php echo URL('../assets/css/bootstrap.min.css') ?>" />
    <link rel="stylesheet" href="<?php echo URL('../assets/fonts/icomoon/style.css') ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css" />
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.3.0/css/all.css" crossorigin="anonymous" />
<!-- Font Awesome 5.15.4 (Stable and widely supported) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-dNmIQG53Fh+zYN+6bqMGv+4RoJsvRYkl+xHDuNGrmJzF+fOY0NvYc6JzjGPs2aF9FsxmD4l4lDClVtW1VrxyFw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Light Theme and Fixes -->
    <style>
        body, .sb-sidenav, .sb-topnav {
            background-color: #fff !important;
            color: #212529;
            font-family: "Noto Sans", sans-serif;
        }

        .sb-topnav {
            border-bottom: 1px solid #ddd;
        }

        .sb-topnav .navbar-brand,
        .sb-topnav .nav-link,
        .sb-sidenav .nav-link,
        .sb-sidenav .sb-sidenav-menu-heading {
            color: #212529;
        }

        .sb-topnav .nav-link:hover,
        .sb-sidenav .nav-link:hover,
        .sb-sidenav .nav-link.active {
            background-color: #f1f1f1;
            color: #000;
        }

        .sb-sidenav .sb-sidenav-footer {
            background-color: #f8f9fa;
            border-top: 1px solid #dee2e6;
        }

        .sb-sidenav-menu .nav-link i {
            color: #0d6efd;
        }

        .dropdown-menu {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .dropdown-item:hover {
            background-color:rgb(155, 142, 142);
        }

        .bg-gradient-primary   { background: linear-gradient(135deg, #4e73df, #224abe); }
        .bg-gradient-info      { background: linear-gradient(135deg, #36b9cc, #1cc88a); }
        .bg-gradient-success   { background: linear-gradient(135deg, #1cc88a, #198754); }
        .bg-gradient-warning   { background: linear-gradient(135deg, #f6c23e, #f0ad4e); }
        .bg-gradient-danger    { background: linear-gradient(135deg, #e74a3b, #c82333); }
        .bg-gradient-secondary { background: linear-gradient(135deg, #979797, #5e5e5e); }
/* Sidebar look */
.sb-sidenav.sb-sidenav-dark {
  background-color: #ffffff !important;   /* white sidebar */
  color: #000 !important;
  border-right: 1px solid #dee2e6;
  font-size: 0.95rem;
}

/* Headings */
.sb-sidenav-dark .sb-sidenav-menu-heading {
  font-size: 0.75rem;
  text-transform: uppercase;
  font-weight: 700;
  color: #6c757d !important;
  margin-top: 1rem;
  margin-bottom: .25rem;
  padding-left: .75rem;
}

/* Links */
.sb-sidenav-dark .nav-link {
  color: #000 !important;
  border-radius: .4rem;
  margin: 2px .5rem;
  padding: .5rem .75rem;
  display: flex;
  align-items: center;
  transition: all .2s ease;
  font-weight: 500;
}

/* Icons */
.sb-sidenav-dark .nav-link i {
  color: #0d6efd !important;
  font-size: 1rem;
  margin-right: .5rem;
}

/* Hover state */
.sb-sidenav-dark .nav-link:hover {
  background-color: #f8f9fa !important;
  color: #000 !important;
  text-decoration: none;
}

/* Active state */
.sb-sidenav-dark .nav-link.active {
  background-color: #e9ecef !important;
  color: #000 !important;
  font-weight: 600;
}

/* Collapsed toggler arrow rotation */
.sb-sidenav-dark .nav-link[data-bs-toggle="collapse"] i.fas.fa-angle-down {
  transition: transform .3s ease;
}
.sb-sidenav-dark .nav-link.collapsed i.fas.fa-angle-down {
  transform: rotate(-90deg);
}

/* Footer */
.sb-sidenav .sb-sidenav-footer {
  background-color: #f8f9fa;
  border-top: 1px solid #dee2e6;
  font-size: 0.85rem;
  text-align: center;
}


    </style>
</head>

<body class="sb-nav-fixed">
    <!-- Top Navigation -->
    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
<a class="navbar-brand ps-3" href="<?php echo ADMINURL ?>">
    <img src="<?php echo ADMINASSETS ?>../../assets/images/logo.png" alt="Logo" height="50">
</a>
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle"><i class="fas fa-bars" style="color: black;"></i></button>

        <ul class="navbar-nav ms-auto me-4">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" data-bs-toggle="dropdown" aria-expanded="false">
                    <img src="<?php echo ADMINASSETS . "images/" . $admin['image'] ?>" width="40" height="40" class="rounded-circle" alt="Admin Avatar" />
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li class="px-3">Welcome <span class="bg-primary text-white px-2 rounded"><?= $admin['username'] ?></span></li>
                    <li><a class="dropdown-item" href="<?php echo ADMINURL ?>admins/profile.php">پروفایل</a></li>
                    <li><hr class="dropdown-divider" /></li>
                    <li><a class="dropdown-item" href="<?php echo ADMINAUTH ?>logout.php">دەرکەتن ژ ئەکاونتی</a></li>
                </ul>
            </li>
        </ul>
    </nav>

    <!-- Sidebar -->
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">

                        <div class="sb-sidenav-menu-heading">سەرەکی</div>
                        <a class="nav-link" href="<?= ADMINURL ?>"><i class="fas fa-tachometer-alt me-2"></i> داشبۆرد</a>

                        <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseAdmins">
                            <i class="fas fa-user-shield me-2"></i> ئەدمین <i class="fas fa-angle-down ms-auto"></i>
                        </a>
                        <div class="collapse" id="collapseAdmins" data-bs-parent="#sidenavAccordion">
                            <nav class="sb-sidenav-menu-nested nav">
                                <a class="nav-link" href="<?= ADMINURL ?>admins/admins-list.php">لیستا ئەدمینا</a>
                                <a class="nav-link" href="<?= ADMINURL ?>admins/add-admin.php">زێدەکرنا ئەدمینەکێ نوی</a>
                            </nav>
                        </div>

                        <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseProperties">
                            <i class="fas fa-building me-2"></i> مولک <i class="fas fa-angle-down ms-auto"></i>
                        </a>
                        <div class="collapse" id="collapseProperties" data-bs-parent="#sidenavAccordion">
                            <nav class="sb-sidenav-menu-nested nav">
                                <a class="nav-link" href="<?= ADMINURL ?>properties/properties-list.php">لیستا مولکا</a>
                                <a class="nav-link" href="<?= ADMINURL ?>properties/add-property.php">زێدەکرنا مولکا</a>
                                <a class="nav-link" href="<?= ADMINURL ?>properties/search-property.php">لێگەریانا مولکا</a>
                            </nav>
                        </div>

                        <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseRequests">
                            <i class="fas fa-envelope-open-text me-2"></i> داخازیێن بکران <i class="fas fa-angle-down ms-auto"></i>
                        </a>
                        <div class="collapse" id="collapseRequests" data-bs-parent="#sidenavAccordion">
                            <nav class="sb-sidenav-menu-nested nav">
                                <a class="nav-link" href="<?= ADMINURL ?>requests/add-client-request.php">زێدەکرنا داخازیان</a>
                                <a class="nav-link" href="<?= ADMINURL ?>requests/requests-list.php">لیستا داخازیێن بکرا</a>
                            </nav>
                        </div>

                        <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseContacts">
                            <i class="fas fa-address-book me-2"></i> ژمارێن بکرا <i class="fas fa-angle-down ms-auto"></i>
                        </a>
                        <div class="collapse" id="collapseContacts" data-bs-parent="#sidenavAccordion">
                            <nav class="sb-sidenav-menu-nested nav">
                                <a class="nav-link" href="<?= ADMINURL ?>contacts/add-contact.php">زێدەکرنا ژمارا موبایلێ</a>
                                <a class="nav-link" href="<?= ADMINURL ?>contacts/contacts-diary.php">لیستا ژمارێن موبایلا</a>
                            </nav>
                        </div>

                    </div>
                </div>

                <div class="sb-sidenav-footer">
                    <div class="small mb-2">Logged in as:</div>
                    <span class="bg-primary text-white px-2 rounded"><?= $admin['username'] ?></span>
                </div>
            </nav>
        </div>

        <div id="layoutSidenav_content">
<!-- Bootstrap JS + dependencies (required for collapse/toggle) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Your sidebar toggle script -->
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const sidebarToggle = document.getElementById("sidebarToggle");
    if (sidebarToggle) {
      sidebarToggle.addEventListener("click", function (e) {
        e.preventDefault();
        document.body.classList.toggle("sb-sidenav-toggled");
      });
    }
  });
</script>
