<?php require_once "includes/header.php"; ?>
<?php
/* -------------------------------------------------
   Server-side: counts & (optional) recent records
--------------------------------------------------*/
$adminsCount = getRowCout('admins');
$usersCount = getRowCout('users');
$categoriesCount = getRowCout('categories');
$propertiesCount = getRowCout('properties');
$requestsCount = getRowCout('requests');

$recentRequests = $recentProperties = [];
function h($v)
{
  return htmlspecialchars((string) $v, ENT_QUOTES, 'UTF-8');
}

try {
  if (isset($pdo) && $pdo instanceof PDO) {
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $recentRequests = $pdo->query("
      SELECT id, client_name, client_phone, property_type, created_at
      FROM client_requests
      ORDER BY created_at DESC
      LIMIT 6
    ")->fetchAll(PDO::FETCH_ASSOC);

    $recentProperties = $pdo->query("
      SELECT id, code, title, property_type, status, created_at
      FROM properties
      ORDER BY created_at DESC
      LIMIT 6
    ")->fetchAll(PDO::FETCH_ASSOC);
  }
} catch (Throwable $e) {
  // Silent: panels auto-hide if empty
}
?>

<main>
  <div class="container-fluid px-4">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-3">
      <div>
        <h2 class="fw-bold mb-0">داشبۆرد</h2>
        <div class="text-muted small">کورتی • دوماهیك ئابدێت: <span id="lastUpdated"></span></div>
      </div>
      <div class="d-flex gap-2">
        <a href="<?= ADMINURL ?>properties/add-property.php" class="btn btn-primary">
          <i class="fas fa-plus-circle me-2"></i>زێدەکرنا مولکی
        </a>
        <a href="<?= ADMINURL ?>requests/add-client-request.php" class="btn btn-outline-primary">
          <i class="fas fa-file-signature me-2"></i>داخازیەکا نوی
        </a>
      </div>
    </div>

    <!-- KPI Cards -->
    <div class="row g-4 mb-4">
      <?php
      $cards = [
        ['label' => 'ئەدمین', 'count' => $adminsCount, 'icon' => 'fa-user-shield', 'color' => '#6c757d', 'url' => 'admins/admins-list.php'],
        ['label' => 'بەکارهێنەران', 'count' => $usersCount, 'icon' => 'fa-users', 'color' => '#0d6efd', 'url' => 'users/users-list.php'],
        ['label' => 'کاتەگۆری', 'count' => $categoriesCount, 'icon' => 'fa-layer-group', 'color' => '#198754', 'url' => 'contacts/contacts-diary.php'],
        ['label' => 'مولک', 'count' => $propertiesCount, 'icon' => 'fa-building', 'color' => '#ffc107', 'url' => 'properties/properties-list.php'],
        ['label' => 'داخازیەکان', 'count' => $requestsCount, 'icon' => 'fa-inbox', 'color' => '#dc3545', 'url' => 'requests/requests-list.php'],
      ];
      foreach ($cards as $c):
        ?>
        <div class="col-xxl-2 col-xl-3 col-md-4 col-sm-6">
          <a href="<?= ADMINURL . $c['url'] ?>" class="text-decoration-none">
            <div class="card shadow-sm border-0 h-100 kpi-card">
              <div class="card-body d-flex align-items-center gap-3">
                <div class="kpi-icon" style="background: <?= $c['color'] ?>1a;">
                  <i class="fas <?= $c['icon'] ?>" style="color: <?= $c['color'] ?>"></i>
                </div>
                <div class="flex-grow-1">
                  <div class="text-muted small mb-1"><?= h($c['label']) ?></div>
                  <div class="fs-4 fw-bold kpi-count" data-target="<?= (int) $c['count'] ?>">0</div>
                </div>
                <i class="fas fa-arrow-right text-muted"></i>
              </div>
            </div>
          </a>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- Charts -->
    <div class="row">
      <!-- Users monthly -->
      <div class="col-xl-6 mb-4">
        <div class="card shadow-sm">
          <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
            <div><i class="fas fa-chart-line me-1 text-primary"></i> تومارکرنا بکارهێنەرا(هەیڤانە)</div>
            <div class="d-flex align-items-center gap-2">
              <button class="btn btn-sm btn-outline-secondary" data-action="download" data-target="myLineChart"><i
                  class="fas fa-download me-1"></i>دانلود</button>
              <button class="btn btn-sm btn-outline-secondary" data-action="refresh"
                data-endpoint="users/get_users_data.php" data-target="myLineChart"><i class="fas fa-rotate me-1"></i>نوی
                کرن</button>
            </div>
          </div>
          <div class="card-body">
            <div class="skeleton" data-skel="line"></div>
            <canvas id="myLineChart" height="200" class="d-none"></canvas>
            <div class="small text-muted mt-2" id="lineChartMeta"></div>
          </div>
        </div>
      </div>
      <!-- Client Requests monthly -->
      <div class="col-xl-6 mb-4" style=".chart-box { height:260px; }">
        <div class="card shadow-sm">
          <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
            <div><i class="fas fa-chart-line me-1 text-primary"></i> داخازیێن بکرا (هەیڤانە)</div>
            <div class="d-flex align-items-center gap-2">
              <button class="btn btn-sm btn-outline-secondary" data-action="download" data-target="myClientReqChart">
                <i class="fas fa-download me-1"></i>دانلود
              </button>
              <button class="btn btn-sm btn-outline-secondary" data-action="refresh"
                data-endpoint="requests/get_client_requests.php" data-target="myClientReqChart">
                <i class="fas fa-rotate me-1"></i>نوی کرن
              </button>
            </div>
          </div>
          <div class="card-body">
            <div class="skeleton" data-skel="requests"></div>

            <!-- fixed height container -->
            <div class="chart-box" style="height:260px">
              <canvas id="myClientReqChart"></canvas>
            </div>

            <div class="small text-muted mt-2 d-flex align-items-center gap-2" id="clientReqMeta"></div>
          </div>
        </div>
      </div>


    </div>

    <!-- Category distribution -->
    <div class="row">
      <div class="col-xl-12 mb-4">
        <div class="card shadow-sm">
          <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
            <div><i class="fas fa-chart-column me-1 text-success"></i> جورێن مولکا</div>
            <div class="d-flex align-items-center gap-2">
              <button class="btn btn-sm btn-outline-secondary" data-action="download" data-target="myBarChart"><i
                  class="fas fa-download me-1"></i>دانلود</button>
              <button class="btn btn-sm btn-outline-secondary" data-action="refresh"
                data-endpoint="categories/get_categories_data.php" data-target="myBarChart"><i
                  class="fas fa-rotate me-1"></i>نوی کرن</button>
            </div>
          </div>
          <div class="card-body">
            <div class="skeleton" data-skel="bar"></div>
            <canvas id="myBarChart" height="200" class="d-none"></canvas>
            <div class="small text-muted mt-2" id="barChartMeta"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Recent Panels -->
    <div class="row">
      <?php if (!empty($recentRequests)): ?>
        <div class="col-xl-6 mb-4">
          <div class="card shadow-sm">
            <div class="card-header bg-light fw-semibold"><i class="fas fa-clock me-1 text-primary"></i> داخازیێن نوی
            </div>
            <div class="table-responsive">
              <table class="table align-middle mb-0">
                <thead class="small text-muted">
                  <tr>
                    <th>ناڤ</th>
                    <th>تەلەفۆن</th>
                    <th>جور</th>
                    <th>دەم</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($recentRequests as $r): ?>
                    <tr>
                      <td><?= h($r['client_name']) ?></td>
                      <td class="text-muted"><?= h($r['client_phone']) ?></td>
                      <td><span class="badge bg-secondary"><?= h($r['property_type']) ?></span></td>
                      <td class="text-muted small"><?= h(date('Y-m-d H:i', strtotime($r['created_at']))) ?></td>
                      <td class="text-end"><a class="btn btn-sm btn-outline-primary"
                          href="<?= ADMINURL ?>requests/requests-list.php?id=<?= (int) $r['id'] ?>">دیارکرن</a></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($recentProperties)): ?>
        <div class="col-12 col-xl-6 mb-4" dir="rtl">
          <div class="card shadow-sm h-100">
            <div class="card-header bg-light fw-semibold d-flex align-items-center gap-2">
              <i class="fas fa-bolt text-warning"></i>
              <span>مولکێن نوی زێدەکری</span>
            </div>

            <div class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead class="small text-muted">
                  <tr>
                    <th style="min-width:80px;">کۆد</th>
                    <th style="min-width:160px;">ناڤونیشان</th>
                    <th class="d-none d-md-table-cell">جور</th>
                    <th class="d-none d-lg-table-cell">بەردەست</th>
                    <th class="d-none d-xl-table-cell">دەم</th>
                    <th class="text-end" style="width:1%;"></th>
                  </tr>
                </thead>

                <tbody>
                  <?php foreach ($recentProperties as $p): ?>
                    <?php
                    $status = strtolower($p['status'] ?? '');
                    $map = ['available' => 'info', 'pending' => 'warning', 'sold' => 'secondary'];
                    $bg = $map[$status] ?? 'secondary';
                    ?>
                    <tr>
                      <!-- Code -->
                      <td>
                        <span class="badge bg-dark"><?= h($p['code']) ?></span>
                      </td>

                      <!-- Title + mobile meta -->
                      <td class="text-truncate" style="max-width: 280px;">
                        <div class="fw-semibold text-wrap"><?= h($p['title']) ?></div>

                        <!-- On small screens, show type/status/time stacked here -->
                        <div class="d-md-none mt-1 small text-muted">
                          <span class="badge bg-info text-dark me-1 mb-1"><?= h($p['property_type']) ?></span>
                          <span class="badge bg-<?= $bg ?> me-1 mb-1"><?= h($p['status'] ?? '—') ?></span>
                          <span class="d-inline-block me-1 mb-1">
                            <?= h(date('Y-m-d H:i', strtotime($p['created_at']))) ?>
                          </span>
                        </div>
                      </td>

                      <!-- Type (md and up) -->
                      <td class="d-none d-md-table-cell">
                        <span class="badge bg-info text-dark"><?= h($p['property_type']) ?></span>
                      </td>

                      <!-- Status (lg and up) -->
                      <td class="d-none d-lg-table-cell">
                        <span class="badge bg-<?= $bg ?>"><?= h($p['status'] ?? '—') ?></span>
                      </td>

                      <!-- Time (xl and up) -->
                      <td class="d-none d-xl-table-cell text-muted small">
                        <?= h(date('Y-m-d H:i', strtotime($p['created_at']))) ?>
                      </td>

                      <!-- Action -->
                      <td class="text-end">
                        <a class="btn btn-sm btn-outline-primary w-100 w-md-auto"
                          href="<?= ADMINURL ?>property-details.php?id=<?= (int) $p['id'] ?>">
                          بینین
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

      <?php endif; ?>
    </div>

  </div>
</main>

<!-- Styles -->
<style>
  .kpi-card {
    transition: transform .15s ease, box-shadow .15s ease;
  }

  .kpi-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .08) !important;
  }

  .kpi-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: grid;
    place-items: center;
    flex: 0 0 48px;
  }

  .kpi-icon i {
    font-size: 1.25rem;
  }

  .skeleton {
    height: 200px;
    border-radius: .5rem;
    background: linear-gradient(90deg, rgba(0, 0, 0, .06) 25%, rgba(0, 0, 0, .12) 37%, rgba(0, 0, 0, .06) 63%);
    background-size: 400% 100%;
    animation: shimmer 1.4s ease-in-out infinite;
  }

  @keyframes shimmer {
    0% {
      background-position: 100% 0
    }

    100% {
      background-position: -100% 0
    }
  }

  @media (prefers-color-scheme: dark) {
    .card-header.bg-light {
      background-color: rgba(255, 255, 255, .08) !important;
    }
  }
</style>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  // Timestamp
  const lastUpdatedEl = document.getElementById('lastUpdated');
  if (lastUpdatedEl) lastUpdatedEl.textContent = new Date().toLocaleString();

  // KPI count-up
  function countUp(el, target, duration = 600) {
    const t0 = performance.now();
    function tick(now) {
      const p = Math.min((now - t0) / duration, 1);
      el.textContent = Math.floor(p * target).toLocaleString();
      if (p < 1) requestAnimationFrame(tick);
    }
    requestAnimationFrame(tick);
  }
  document.querySelectorAll('.kpi-count').forEach(el => countUp(el, Number(el.dataset.target || 0)));

  // Fetch helper (retry + timeout)
  async function fetchJson(endpoint, { retries = 1, timeoutMs = 10000 } = {}) {
    for (let a = 0; a <= retries; a++) {
      const ctrl = new AbortController();
      const timer = setTimeout(() => ctrl.abort(), timeoutMs);
      try {
        const res = await fetch(endpoint, { signal: ctrl.signal, headers: { 'Cache-Control': 'no-cache' } });
        clearTimeout(timer);
        if (!res.ok) throw new Error('HTTP ' + res.status);
        return await res.json();
      } catch (e) {
        clearTimeout(timer);
        if (a === retries) throw e;
        await new Promise(r => setTimeout(r, 600 * (a + 1)));
      }
    }
  }

  // Chart builders
  let lineChart, propsAddedChart, catsChart;

  function renderUsersMonthly(rows) {
    const skel = document.querySelector('[data-skel="line"]');
    const el = document.getElementById('myLineChart');
    skel?.classList.add('d-none'); el.classList.remove('d-none');
    lineChart?.destroy();
    lineChart = new Chart(el.getContext('2d'), {
      type: 'line',
      data: {
        labels: rows.map(r => r.month),
        datasets: [{
          label: 'New Users',
          data: rows.map(r => Number(r.user_count || 0)),
          borderColor: '#0d6efd', backgroundColor: 'rgba(13,110,253,.12)', fill: true, tension: .35, pointRadius: 3
        }]
      },
      options: {
        responsive: true, plugins: { legend: { display: true }, tooltip: { mode: 'index', intersect: false } },
        interaction: { mode: 'index', intersect: false }, scales: { y: { beginAtZero: true, ticks: { precision: 0 } } }
      }
    });
    document.getElementById('lineChartMeta').textContent = `مانگانە • خشتەکان: ${rows.length}`;
  }

  function renderPropsAdded(rows) {
    const skel = document.querySelector('[data-skel="props"]');
    const el = document.getElementById('myPropsAddedChart');
    skel?.classList.add('d-none'); el.classList.remove('d-none');
    propsAddedChart?.destroy();
    propsAddedChart = new Chart(el.getContext('2d'), {
      type: 'bar',
      data: {
        labels: rows.map(r => r.month),
        datasets: [{
          label: 'Properties Added', data: rows.map(r => Number(r.count || 0)),
          backgroundColor: '#198754', borderRadius: 6, barThickness: 'flex'
        }]
      },
      options: {
        responsive: true, plugins: { legend: { display: false } },
        scales: { y: { beginAtZero: true, ticks: { precision: 0 } } }
      }
    });
    const sum = rows.reduce((s, r) => s + Number(r.count || 0), 0);
    document.getElementById('propsAddedMeta').textContent = `هەیڤانە • مەجموع: ${sum.toLocaleString()}`;
  }

  function renderCats(rows) {
    const skel = document.querySelector('[data-skel="bar"]');
    const el = document.getElementById('myBarChart');
    skel?.classList.add('d-none'); el.classList.remove('d-none');
    catsChart?.destroy();
    catsChart = new Chart(el.getContext('2d'), {
      type: 'bar',
      data: {
        labels: rows.map(r => r.name),
        datasets: [{
          label: 'Properties', data: rows.map(r => Number(r.property_count || 0)),
          backgroundColor: '#20c997', borderRadius: 6, barThickness: 'flex'
        }]
      },
      options: {
        responsive: true, plugins: { legend: { display: false } },
        scales: { y: { beginAtZero: true, ticks: { precision: 0 } } }
      }
    });
    document.getElementById('barChartMeta').textContent = `جور: ${rows.length}`;
  }

  // Load charts
  async function initCharts() {
    try {
      const users = await fetchJson('users/get_users_data.php');
      users?.length ? renderUsersMonthly(users)
        : document.getElementById('lineChartMeta').textContent = 'داتا بەردەست نینن.';
    } catch { document.getElementById('lineChartMeta').textContent = 'ئیرور وەرگرتنا داتایا'; }

    try {
      const props = await fetchJson('properties/get_properties_added.php');
      props?.length ? renderPropsAdded(props)
        : document.getElementById('propsAddedMeta').textContent = 'داتا بەردەست نینن';
    } catch { document.getElementById('propsAddedMeta').textContent = 'ئیرور وەرگرتنا داتایا'; }

    try {
      const cats = await fetchJson('categories/get_categories_data.php');
      cats?.length ? renderCats(cats)
        : document.getElementById('barChartMeta').textContent = 'داتا بەردەست نینن';
    } catch { document.getElementById('barChartMeta').textContent = 'ئیرور وەرگرتنا داتایا'; }
  }
  initCharts();

  // Toolbar actions
  function downloadChart(id) {
    const c = document.getElementById(id); if (!c) return;
    const a = document.createElement('a'); a.href = c.toDataURL('image/png'); a.download = id + '.png'; a.click();
  }
  async function refreshChart(btn) {
    const target = btn.dataset.target, endpoint = btn.dataset.endpoint; if (!target || !endpoint) return;
    const skelSel = target === 'myLineChart' ? '[data-skel="line"]' : (target === 'myPropsAddedChart' ? '[data-skel="props"]' : '[data-skel="bar"]');
    document.querySelector(skelSel)?.classList.remove('d-none'); document.getElementById(target).classList.add('d-none');
    try {
      const rows = await fetchJson(endpoint, { retries: 1 });
      if (target === 'myLineChart') renderUsersMonthly(rows);
      else if (target === 'myPropsAddedChart') renderPropsAdded(rows);
      else renderCats(rows);
    } catch {
      const metaId = target === 'myLineChart' ? 'lineChartMeta' : (target === 'myPropsAddedChart' ? 'propsAddedMeta' : 'barChartMeta');
      document.getElementById(metaId).textContent = 'ئیرور ل نویکرنێ دا';
    }
  }
  document.querySelectorAll('[data-action="download"]').forEach(b => b.addEventListener('click', () => downloadChart(b.dataset.target)));
  document.querySelectorAll('[data-action="refresh"]').forEach(b => b.addEventListener('click', () => refreshChart(b)));
</script>
<!-- 1) Make sure Chart.js is loaded once on the page -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>

<script>
  (function () {
    // Utility: qs
    const $ = (sel, root = document) => root.querySelector(sel);

    // -------- Core loader for the Client Requests card --------
    async function renderClientRequestsCard() {
      const refreshBtn = document.querySelector('[data-action="refresh"][data-target="myClientReqChart"]');
      const downloadBtn = document.querySelector('[data-action="download"][data-target="myClientReqChart"]');
      const endpoint = refreshBtn?.dataset.endpoint || 'requests/get_client_requests.php';

      const skel = document.querySelector('[data-skel="requests"]');
      const canvas = document.getElementById('myClientReqChart');
      const meta = document.getElementById('clientReqMeta');

      if (!canvas) return console.warn('Canvas #myClientReqChart not found');

      // show skeleton
      skel && (skel.style.display = 'block');
      canvas.classList.add('d-none');

      let payload;
      try {
        const res = await fetch(endpoint, { cache: 'no-store' });
        const text = await res.text();

        // Useful when PHP notices leak into JSON
        const startJson = text.indexOf('{');
        const endJson = text.lastIndexOf('}');
        const safe = (startJson >= 0 && endJson >= 0) ? text.slice(startJson, endJson + 1) : text;

        payload = JSON.parse(safe);
        if (!payload.ok) throw new Error(payload.error || 'Endpoint returned ok:false');
      } catch (err) {
        console.error('Failed to load client requests:', err);
        skel && (skel.innerHTML = '<div class="text-danger small">ئیرور وەرگرتنا داتایا</div>');
        return;
      }

      // data
      const labels = payload.labels || [];
      const data = payload.data || [];

      // build / update chart
      // build / update chart
      const ctx = canvas.getContext('2d');

      // optional: subtle gradient fill
      const grad = ctx.createLinearGradient(0, 0, 0, 260);
      grad.addColorStop(0, 'rgba(13,110,253,0.25)');  // top
      grad.addColorStop(1, 'rgba(13,110,253,0.05)');  // bottom

      const datasetCommon = {
        label: 'Client Requests',
        data,
        backgroundColor: grad,
        borderColor: 'rgba(13,110,253,0.7)',
        hoverBackgroundColor: 'rgba(13,110,253,0.6)',
        borderWidth: 1.5,
        borderRadius: 6,         // rounded bars
        maxBarThickness: 24,     // keep bars slim
      };

      const config = {
        type: 'bar', // 'line' also looks great with the same height container
        data: { labels, datasets: [datasetCommon] },
        options: {
          responsive: true,
          maintainAspectRatio: false,   // respect our fixed container height
          layout: { padding: { top: 4, right: 8, bottom: 0, left: 8 } },
          scales: {
            x: {
              grid: { display: false },
              ticks: { maxRotation: 0, autoSkip: true, font: { size: 11 } },
            },
            y: {
              beginAtZero: true,
              ticks: { precision: 0, font: { size: 11 } },
              grid: { color: 'rgba(0,0,0,0.06)' },
              border: { display: false },
            }
          },
          plugins: {
            legend: { display: false },
            tooltip: { intersect: false, mode: 'index' },
            title: { display: false }
          },
          animation: { duration: 300 }
        }
      };

      if (canvas.__chart) {
        canvas.__chart.data.labels = labels;
        canvas.__chart.data.datasets[0].data = data;
        canvas.__chart.update();
      } else {
        canvas.__chart = new Chart(ctx, config);
      }
      if (canvas.__chart) {
        canvas.__chart.data.labels = labels;
        canvas.__chart.data.datasets[0].data = data;
        canvas.__chart.update();
      } else {
        canvas.__chart = new Chart(ctx, {
          type: 'bar', // change to 'line' if you prefer
          data: {
            labels,
            datasets: [{
              label: 'Client Requests (per month)',
              data,
              // styling kept minimal; Chart.js uses defaults
              borderWidth: 1
            }]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
              y: { beginAtZero: true, ticks: { precision: 0 } }
            },
            plugins: {
              legend: { display: false },
              tooltip: { intersect: false, mode: 'index' }
            }
          }
        });
      }

      // Meta text
      const f = payload.meta || {};
      meta && (meta.textContent =
        `گشت: ${payload.total ?? 0} | ماوە: ${f.start ?? ''} → ${f.end ?? ''}` +
        (f.filters?.property_type ? ` | جۆرێ مولکی: ${f.filters.property_type}` : '')
      );

      // show canvas, hide skeleton
      skel && (skel.style.display = 'none');
      canvas.classList.remove('d-none');
    }

    // -------- Button wiring (refresh / download) --------
    function wireClientRequestButtons() {
      const refreshBtn = document.querySelector('[data-action="refresh"][data-target="myClientReqChart"]');
      const downloadBtn = document.querySelector('[data-action="download"][data-target="myClientReqChart"]');
      const canvas = document.getElementById('myClientReqChart');

      refreshBtn && refreshBtn.addEventListener('click', (e) => {
        e.preventDefault();
        renderClientRequestsCard();
      });

      downloadBtn && downloadBtn.addEventListener('click', (e) => {
        e.preventDefault();
        if (!canvas || !canvas.__chart) return;
        const link = document.createElement('a');
        link.download = `client-requests-${new Date().toISOString().slice(0, 10)}.png`;
        link.href = canvas.toDataURL('image/png', 1.0);
        link.click();
      });
    }

    // Init on DOM ready
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', () => {
        wireClientRequestButtons();
        renderClientRequestsCard();
      });
    } else {
      wireClientRequestButtons();
      renderClientRequestsCard();
    }
  })();
</script>

<?php require_once "includes/footer.php"; ?>