<?php
$type = $_GET['type'] ?? '';

function field($name, $placeholder, $type = 'text', $step = '', $extra = '') {
  $stepAttr = $step ? " step=\"$step\"" : '';
  return "<input type=\"$type\" name=\"$name\" class=\"form-control mb-2\" placeholder=\"$placeholder\"$stepAttr $extra />";
}

function textarea($name, $placeholder) {
  return "<textarea name=\"$name\" class=\"form-control mb-2\" placeholder=\"$placeholder\"></textarea>";
}

if ($type === 'house') {
  echo field('area', 'Area');
  echo field('street', 'Street');
  echo field('size', 'Size (m²)', 'number', '0.01');
  echo field('direction', 'Direction');
  echo field('unit', 'Unit');
  echo field('year', 'Built Year', 'number') . PHP_EOL;
  echo field('house_number', 'House Number');
  echo field('price', 'Price', 'number', '0.01');
  echo textarea('note', 'Note');

} elseif ($type === 'land') {
  echo field('area', 'Area');
  echo field('street', 'Street');
  echo field('size', 'Size (m²)', 'number', '0.01');
  echo field('direction', 'Direction');
  echo field('land_number', 'Land Number');
  echo field('price', 'Price', 'number', '0.01');

} elseif ($type === 'installment') {
  echo field('residence', 'Residential Name');
  echo field('size', 'Size', 'number', '0.01');
  echo field('floor', 'Floor', 'number');
  echo field('tower', 'Tower Number');
  echo field('direction', 'Direction');
  echo field('paid', 'Paid Amount', 'number', '0.01');
  echo field('monthly', 'Monthly Installment', 'number', '0.01');
  echo field('remaining', 'Remaining to Company', 'number', '0.01');
  echo field('total', 'Total Price', 'number', '0.01');

} elseif ($type === 'cash') {
  echo field('residence', 'Residential Name');
  echo field('size', 'Size', 'number', '0.01');
  echo field('tower', 'Tower Number');
  echo field('direction', 'Direction');
  echo field('price', 'Price', 'number', '0.01');

} else {
  echo "<p class='text-muted'>Please select a property type to see details.</p>";
}
