<?php
require_once "../includes/header.php";
require_once "../../functions/database.php";

$pdo = new PDO("mysql:host=localhost;dbname=homeland;charset=utf8mb4", "root", "");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Get property ID
$id = $_GET['id'] ?? null;
if (!$id) die("Property ID missing.");

// Fetch property
$stmt = $pdo->prepare("SELECT * FROM properties WHERE id = ?");
$stmt->execute([$id]);
$property = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$property) die("Property not found.");

// Helper
function isType($type, $current) {
    return $type === $current ? 'selected' : '';
}
function showIf($type, $current) {
    return $type === $current ? 'block' : 'none';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>ئاپدەیتکرن</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-section { display: none; }
    </style>
</head>
<body class="bg-light p-4">

<div class="container bg-white p-4 rounded shadow">
    <h2>ئاپدەیتکرن</h2>
    <form method="POST" action="update-property.php" enctype="multipart/form-data">
          <input type="hidden" name="property_id" value="<?= $property['id'] ?>">




        <div class="mb-3">
            <label>جورێ مولکی</label>

<input type="hidden" name="property_type" id="propertyType" value="<?= htmlspecialchars($property['property_type']) ?>">
<input type="text" class="form-control" value="<?= htmlspecialchars($property['property_type']) ?>" disabled>

        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>خودان</label>
                <input type="text" name="owner_name" class="form-control" value="<?= htmlspecialchars($property['owner_name']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label>ژمارا خودانی</label>
                <input type="text" name="owner_phone" class="form-control" value="<?= htmlspecialchars($property['owner_phone']) ?>" required>
            </div>
        </div>

        <div class="mb-3">
            <label>ناڤێ مولکی</label>
            <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($property['title']) ?>" required>
        </div>

        <div class="mb-3">
            <label>کورتی</label>
            <textarea name="description" class="form-control"><?= htmlspecialchars($property['description']) ?></textarea>
        </div>

        <!-- HOUSE -->
<div class="form-section" id="houseFields">
    <h5>خانی</h5>
    <input type="text" name="area" class="form-control mb-2" placeholder="گەرەک" value="<?= htmlspecialchars($property['area']) ?>">
    <input type="text" name="street_address" class="form-control mb-2" placeholder="جادە" value="<?= htmlspecialchars($property['street_address']) ?>">
    <input type="number" step="0.01" name="size_sqft" class="form-control mb-2" placeholder="رووبەر" value="<?= $property['size_sqft'] ?>">
    <input type="text" name="directions" class="form-control mb-2" placeholder="اتجاهـ" value="<?= htmlspecialchars($property['directions']) ?>">
    <input type="text" name="unit" class="form-control mb-2" placeholder="Unit" value="<?= htmlspecialchars($property['unit']) ?>">
    <input type="number" name="year_built" class="form-control mb-2" placeholder="سالا یاڤاکرنێ" value="<?= $property['year_built'] ?>">
    <input type="text" name="house_number" class="form-control mb-2" placeholder="ژمارا خانی" value="<?= htmlspecialchars($property['house_number']) ?>">
    <input type="number" name="rooms" class="form-control mb-2" placeholder="ژوور" value="<?= $property['rooms'] ?>">
    <input type="number" step="0.01" name="price" class="form-control mb-2" placeholder="بها" value="<?= $property['price'] ?>">
    <textarea name="note" class="form-control mb-2" placeholder="Note"><?= htmlspecialchars($property['note']) ?></textarea>
</div>

<!-- LAND -->
<div class="form-section" id="landFields">
    <h5>عەرد</h5>
    <input type="text" name="area" class="form-control mb-2" placeholder="گەرەک" value="<?= htmlspecialchars($property['area']) ?>">
    <input type="text" name="street_address" class="form-control mb-2" placeholder="جادە" value="<?= htmlspecialchars($property['street_address']) ?>">
    <input type="number" step="0.01" name="size_sqft" class="form-control mb-2" placeholder="رووبەر" value="<?= $property['size_sqft'] ?>">
    <input type="text" name="directions" class="form-control mb-2" placeholder="اتجاهـ" value="<?= htmlspecialchars($property['directions']) ?>">
    <input type="text" name="land_number" class="form-control mb-2" placeholder="ژمارا عەردی" value="<?= htmlspecialchars($property['land_number']) ?>">
    <input type="number" step="0.01" name="price" class="form-control mb-2" placeholder="بها" value="<?= $property['price'] ?>">
</div>

<!-- INSTALLMENT -->
<div class="form-section" id="installmentFields">
    <h5>شقە قست</h5>
    <input type="text" name="residence_name" class="form-control mb-2" placeholder="پروژە" value="<?= htmlspecialchars($property['residence_name']) ?>">
    <input type="number" step="0.01" name="size_sqft" class="form-control mb-2" placeholder="رووبەر" value="<?= $property['size_sqft'] ?>">
    <input type="text" name="floor" class="form-control mb-2" placeholder="تابقێ شقێ" value="<?= htmlspecialchars($property['floor']) ?>">
    <input type="text" name="tower_number" class="form-control mb-2" placeholder="ژمارا تاوەری" value="<?= htmlspecialchars($property['tower_number']) ?>">
    <input type="text" name="directions" class="form-control mb-2" placeholder="اتجاهـ" value="<?= htmlspecialchars($property['directions']) ?>">
    <input type="number" name="rooms" class="form-control mb-2" placeholder="ژوور" value="<?= $property['rooms'] ?>">
    <input type="number" step="0.01" name="money_paid" class="form-control mb-2" placeholder="پارێ هاتیە دان" value="<?= $property['money_paid'] ?>">
    <input type="number" step="0.01" name="monthly_installment" class="form-control mb-2" placeholder="قستێ هەیڤانە" value="<?= $property['monthly_installment'] ?>">
    <input type="number" step="0.01" name="remain_amount" class="form-control mb-2" placeholder="پارێ مای" value="<?= $property['remain_amount'] ?>">
    <input type="number" step="0.01" name="total_price" class="form-control mb-2" placeholder="مجموع بهایێ شقێ" value="<?= $property['total_price'] ?>">
</div>

<!-- CASH -->
<div class="form-section" id="cashFields">
    <h5>شقە کاش</h5>
    <input type="text" name="residence_name" class="form-control mb-2" placeholder="پروژە" value="<?= htmlspecialchars($property['residence_name']) ?>">
    <input type="number" step="0.01" name="size_sqft" class="form-control mb-2" placeholder="رووبەر" value="<?= $property['size_sqft'] ?>">
    <input type="text" name="tower_number" class="form-control mb-2" placeholder="ژمارا تاوەری" value="<?= htmlspecialchars($property['tower_number']) ?>">
    <input type="text" name="directions" class="form-control mb-2" placeholder="اتجاهـ" value="<?= htmlspecialchars($property['directions']) ?>">
    <input type="number" name="rooms" class="form-control mb-2" placeholder="ژوور" value="<?= $property['rooms'] ?>">
    <input type="number" step="0.01" name="price" class="form-control mb-2" placeholder="بها" value="<?= $property['price'] ?>">
</div>


        <button type="submit" name="submit" class="btn btn-success mt-3">ئاپدەیت بکە</button>
    </form>
</div>

<script>
function toggleFields() {
    const type = document.getElementById('propertyType').value;
    document.querySelectorAll('.form-section').forEach(s => s.style.display = 'none');

    if (type === 'house') {
        document.getElementById('houseFields').style.display = 'block';
    } else if (type === 'land') {
        document.getElementById('landFields').style.display = 'block';
    } else if (type === 'Apartment (Installment)') {
        document.getElementById('installmentFields').style.display = 'block';
    } else if (type === 'Apartment (Cash)') {
        document.getElementById('cashFields').style.display = 'block';
    }
}

window.onload = () => {
    // Don't modify dropdown on load, just use the selected value
    toggleFields();
};

</script>

</body>
</html>
