<?php
// properties/get_properties_added.php
declare(strict_types=1);

// include ONLY your DB bootstrap that creates $pdo (no HTML output!)
require_once __DIR__ . '/../includes/boot.php'; // or your database init

header('Content-Type: application/json; charset=utf-8');

// Optional: clear any accidental output from includes
if (function_exists('ob_get_length')) { while (ob_get_length()) { ob_end_clean(); } }

try {
    $sql = "
      SELECT DATE_FORMAT(created_at, '%Y-%m') AS month, COUNT(*) AS count
      FROM properties
      WHERE created_at >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 11 MONTH), '%Y-%m-01')
      GROUP BY DATE_FORMAT(created_at, '%Y-%m')
      ORDER BY month ASC
    ";
    $stmt = $pdo->query($sql);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Fill missing months
    $map = [];
    foreach ($rows as $r) $map[$r['month']] = (int)$r['count'];

    $out = [];
    $start = new DateTime(date('Y-m-01', strtotime('-11 months')));
    for ($i = 0; $i < 12; $i++) {
        $m = $start->format('Y-%m');
        $out[] = ['month' => $m, 'count' => $map[$m] ?? 0];
        $start->modify('+1 month');
    }

    echo json_encode($out, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
}
exit;
