<?php require_once "../includes/header.php"; ?>
<?php require_once "../../functions/database.php"; ?>

<style>
/* Polished look */
.card-property{
  transition:transform .08s ease-in-out, box-shadow .1s ease-in-out;
  border-radius:.75rem;
}
.card-property:hover{transform:translateY(-2px); box-shadow:0 6px 18px rgba(0,0,0,.08);}
.badge-type{text-transform:capitalize;}
.text-truncate-2{display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;}
.btn-loading{display:inline-flex; align-items:center; gap:.5rem;}
.btn-loading .spinner-border{width:1rem; height:1rem; border-width:.15rem;}
</style>

<?php
// ---------- INPUTS ----------
$g = fn($k,$d='') => isset($_GET[$k]) ? trim((string)$_GET[$k]) : $d;

$q        = $g('q');                     // search title/code
$type     = $g('type');                  // property_type enum
$pstatus  = $g('pstatus');               // property_status enum
$avail    = $g('avail');                 // status enum (Available/Sold)
$area     = $g('area');                  // text LIKE
$sizeMin  = $g('size_min');              // size_sqft min
$sizeMax  = $g('size_max');              // size_sqft max
$priceMin = $g('price_min');             // price min
$priceMax = $g('price_max');             // price max
$yearMin  = $g('year_min');              // year_built min
$yearMax  = $g('year_max');              // year_built max
$sortKey  = $g('sort','newest');         // whitelist below
$page     = max(1, (int)$g('page', 1));
$perPageQ = $g('per_page','12');         // 'all' or int

$showAll  = ($perPageQ === 'all');
$perPage  = $showAll ? null : max(1, (int)$perPageQ);

// ---------- SORT WHITELIST (MySQL/MariaDB safe) ----------
$sortMap = [
  'newest'     => 'created_at DESC',
  'oldest'     => 'created_at ASC',
  'price_desc' => 'price IS NULL ASC, price DESC',
  'price_asc'  => 'price IS NULL ASC, price ASC',
  'size_desc'  => 'size_sqft IS NULL ASC, size_sqft DESC',
  'size_asc'   => 'size_sqft IS NULL ASC, size_sqft ASC',
  'title_az'   => 'title ASC',
  'title_za'   => 'title DESC',
];
$orderBy = $sortMap[$sortKey] ?? $sortMap['newest'];

// ---------- WHERE + PARAMS (positional only) ----------
$where  = [];
$params = [];

if ($q !== '') {
  $where[]  = '(title LIKE ? OR code LIKE ?)';
  $params[] = "%{$q}%";
  $params[] = "%{$q}%";
}
if ($type !== '')    { $where[] = 'property_type = ?';     $params[] = $type; }
if ($pstatus !== '') { $where[] = 'property_status = ?';   $params[] = $pstatus; }
if ($avail !== '')   { $where[] = 'status = ?';            $params[] = $avail; }
if ($area !== '')    { $where[] = 'area LIKE ?';           $params[] = "%{$area}%"; }

if ($sizeMin !== '' && is_numeric($sizeMin)) { $where[] = 'size_sqft >= ?'; $params[] = (float)$sizeMin; }
if ($sizeMax !== '' && is_numeric($sizeMax)) { $where[] = 'size_sqft <= ?'; $params[] = (float)$sizeMax; }

if ($priceMin !== '' && is_numeric($priceMin)) { $where[] = 'price >= ?'; $params[] = (float)$priceMin; }
if ($priceMax !== '' && is_numeric($priceMax)) { $where[] = 'price <= ?'; $params[] = (float)$priceMax; }

if ($yearMin !== '' && ctype_digit($yearMin)) { $where[] = 'year_built >= ?'; $params[] = (int)$yearMin; }
if ($yearMax !== '' && ctype_digit($yearMax)) { $where[] = 'year_built <= ?'; $params[] = (int)$yearMax; }

$whereSQL = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

// ---------- TOTAL COUNT ----------
$stmtCount = $pdo->prepare("SELECT COUNT(*) FROM properties $whereSQL");
$stmtCount->execute($params);
$totalRows = (int)$stmtCount->fetchColumn();

$totalPages = $showAll ? 1 : (int)max(1, ceil($totalRows / $perPage));
$page   = $showAll ? 1 : min($page, $totalPages);
$offset = $showAll ? 0 : (($page - 1) * $perPage);

// ---------- FILTER OPTIONS ----------
$types = $pdo->query("SELECT DISTINCT property_type FROM properties WHERE COALESCE(property_type,'')<>'' ORDER BY property_type")->fetchAll(PDO::FETCH_COLUMN);
$pstatuses = $pdo->query("SELECT DISTINCT property_status FROM properties WHERE COALESCE(property_status,'')<>'' ORDER BY property_status")->fetchAll(PDO::FETCH_COLUMN);
$avails = $pdo->query("SELECT DISTINCT status FROM properties WHERE COALESCE(status,'')<>'' ORDER BY status")->fetchAll(PDO::FETCH_COLUMN);

// ---------- MAIN QUERY ----------
$sql = "SELECT id, code, title, price, property_type, property_status, status, area, size_sqft, year_built, created_at
        FROM properties
        $whereSQL
        ORDER BY $orderBy " . ($showAll ? "" : "LIMIT ? OFFSET ?");

$stmt = $pdo->prepare($sql);
$i = 1;
foreach ($params as $v) $stmt->bindValue($i++, $v);
if (!$showAll) {
  $stmt->bindValue($i++, (int)$perPage, PDO::PARAM_INT);
  $stmt->bindValue($i++, (int)$offset,  PDO::PARAM_INT);
}
$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Helper to keep parts of query string
function qs_keep(array $keep, array $override = []): string {
  $now = array_intersect_key($_GET, array_flip($keep));
  $q = array_merge($now, $override);
  return http_build_query(array_filter($q, fn($v) => $v !== '' && $v !== null));
}
function render_pager(int $page, int $totalPages, callable $mk): string {
    if ($totalPages <= 1) return '';
    ob_start(); ?>
    <nav aria-label="Pagination">
      <ul class="pagination pagination-sm mb-0">
        <li class="page-item <?= $page<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= $page<=1?'#':$mk($page-1) ?>" aria-label="Previous">&laquo;</a>
        </li>
        <?php
          $start = max(1, $page-2);
          $end   = min($totalPages, $page+2);
          if ($start > 1) {
            echo '<li class="page-item"><a class="page-link" href="'. $mk(1) .'">1</a></li>';
            if ($start > 2) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
          }
          for ($p=$start; $p<=$end; $p++) {
            $active = $p===$page ? 'active' : '';
            echo '<li class="page-item '.$active.'"><a class="page-link" href="'. $mk($p) .'">'.$p.'</a></li>';
          }
          if ($end < $totalPages) {
            if ($end < $totalPages-1) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
            echo '<li class="page-item"><a class="page-link" href="'. $mk($totalPages) .'">'.$totalPages.'</a></li>';
          }
        ?>
        <li class="page-item <?= $page>=$totalPages?'disabled':'' ?>">
          <a class="page-link" href="<?= $page>=$totalPages?'#':$mk($page+1) ?>" aria-label="Next">&raquo;</a>
        </li>
      </ul>
    </nav>
    <?php return ob_get_clean();
}
// Badge helpers
function badgeClass($val, $map) { return $map[$val] ?? 'bg-secondary'; }

$typeClasses = [
  'House'=>'bg-primary-subtle text-primary border border-primary-subtle',
  'Land'=>'bg-success-subtle text-success border border-success-subtle',
  'Apartment (Installment)'=>'bg-warning-subtle text-warning border border-warning-subtle',
  'Apartment (Cash)'=>'bg-info-subtle text-info border border-info-subtle',
];
$availClasses = ['Available'=>'bg-success', 'Sold'=>'bg-danger'];
?>
<div class="container mt-5 pt-5">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h2 class="mb-0">لیستا مولکا</h2>
      <div class="text-muted small mt-1">
        <?php
          if ($totalRows === 0) echo "No results";
          else {
            $range = $showAll ? "all {$totalRows}" : (($offset+1).'–'.min($offset+($perPage??$totalRows), $totalRows)." of {$totalRows}");
            echo "Showing {$range}";
          }
        ?>
      </div>
    </div>
    <div class="d-flex align-items-center gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="?">ژێبرنا فلتەری</a>
      <?php if ($showAll): ?>
        <a class="btn btn-outline-primary btn-sm" href="?<?= qs_keep(['q','type','pstatus','avail','area','size_min','size_max','price_min','price_max','year_min','year_max','sort'], ['per_page'=>'12','page'=>1]) ?>">ستایلێ پەیج</a>
      <?php else: ?>
        <a class="btn btn-primary btn-sm" href="?<?= qs_keep(['q','type','pstatus','avail','area','size_min','size_max','price_min','price_max','year_min','year_max','sort'], ['per_page'=>'all']) ?>">هەمیا دیاربکە</a>
      <?php endif; ?>
    </div>
  </div>

  <!-- Filters (live apply) -->
  <form id="filtersForm" method="get" class="card card-body mb-4 shadow-sm">
    <div class="row g-3">
      <div class="col-md-3">
        <label class="form-label mb-1">کود</label>
        <input type="search" class="form-control js-auto" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="e.g. 5188 or villa" data-debounce="400">
      </div>

      <div class="col-md-2">
        <label class="form-label mb-1">جور</label>
        <select class="form-select js-auto" name="type" data-submit="instant">
          <option value="">All</option>
          <?php foreach ($types as $t): ?>
            <option value="<?= htmlspecialchars($t) ?>" <?= $t===$type?'selected':'' ?>><?= htmlspecialchars($t) ?></option>
          <?php endforeach; ?>
        </select>
      </div>


      <div class="col-md-2">
        <label class="form-label mb-1">بەردەستە / فروتیە</label>
        <select class="form-select js-auto" name="avail" data-submit="instant">
          <option value="">All</option>
          <?php foreach ($avails as $a): ?>
            <option value="<?= htmlspecialchars($a) ?>" <?= $a===$avail?'selected':'' ?>><?= htmlspecialchars($a) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-2">
        <label class="form-label mb-1">گەڕەك</label>
        <input type="text" class="form-control js-auto" name="area" value="<?= htmlspecialchars($area) ?>" placeholder="e.g. Masik" data-debounce="400">
      </div>

      <div class="col-md-2">
        <label class="form-label mb-1">رووبەر ژ-</label>
        <input type="number" class="form-control js-auto" name="size_min" value="<?= htmlspecialchars($sizeMin) ?>" min="0" step="1" data-debounce="400">
      </div>
      <div class="col-md-2">
        <label class="form-label mb-1">روبەر هەتا+</label>
        <input type="number" class="form-control js-auto" name="size_max" value="<?= htmlspecialchars($sizeMax) ?>" min="0" step="1" data-debounce="400">
      </div>

      <div class="col-md-2">
        <label class="form-label mb-1">بها ژ-</label>
        <input type="number" class="form-control js-auto" name="price_min" value="<?= htmlspecialchars($priceMin) ?>" min="0" step="1" data-debounce="400">
      </div>
      <div class="col-md-2">
        <label class="form-label mb-1">بها هەتا+</label>
        <input type="number" class="form-control js-auto" name="price_max" value="<?= htmlspecialchars($priceMax) ?>" min="0" step="1" data-debounce="400">
      </div>

      <div class="col-md-2">
        <label class="form-label mb-1">ژ سالا*</label>
        <input type="number" class="form-control js-auto" name="year_min" value="<?= htmlspecialchars($yearMin) ?>" min="1900" max="2099" step="1" data-debounce="400">
      </div>
      <div class="col-md-2">
        <label class="form-label mb-1">هەتا سالا*</label>
        <input type="number" class="form-control js-auto" name="year_max" value="<?= htmlspecialchars($yearMax) ?>" min="1900" max="2099" step="1" data-debounce="400">
      </div>

      <div class="col-md-3">
        <label class="form-label mb-1">رێزبەندی</label>
        <select class="form-select js-auto" name="sort" data-submit="instant">
          <option value="newest"     <?= $sortKey==='newest'?'selected':'' ?>>نوی دەسپێکێ</option>
          <option value="oldest"     <?= $sortKey==='oldest'?'selected':'' ?>>کەڤن دەسپێکێ</option>
          <option value="price_desc" <?= $sortKey==='price_desc'?'selected':'' ?>>بها: گران بو ئەرزان</option>
          <option value="price_asc"  <?= $sortKey==='price_asc'?'selected':'' ?>>بها: ئەرزان بو گران</option>
          <option value="size_desc"  <?= $sortKey==='size_desc'?'selected':'' ?>>رووبەر: مازن بو بچیك</option>
          <option value="size_asc"   <?= $sortKey==='size_asc'?'selected':'' ?>>رووبەر: بچیك بو مازنی</option>
          <option value="title_az"   <?= $sortKey==='title_az'?'selected':'' ?>>ناڤێ مولکی A→Z</option>
          <option value="title_za"   <?= $sortKey==='title_za'?'selected':'' ?>>ناڤێ مولکی Z→A</option>
        </select>
      </div>
    </div>

    <div class="d-flex align-items-center gap-2 mt-3">
      <?php if (!$showAll): ?>
        <div class="input-group" style="max-width: 220px;">
          <label class="input-group-text" for="per_page">هەر پەیجەکێ</label>
          <select class="form-select js-auto" id="per_page" name="per_page" data-submit="instant">
            <?php foreach ([6,12,18,24,36,48] as $n): ?>
              <option value="<?= $n ?>" <?= (string)$perPage === (string)$n ? 'selected':'' ?>><?= $n ?></option>
            <?php endforeach; ?>
            <option value="all" <?= $showAll?'selected':'' ?>>هەمی</option>
          </select>
        </div>
      <?php else: ?>
        <input type="hidden" name="per_page" value="all">
      <?php endif; ?>

      <noscript><button class="btn btn-primary">جێبەجێکرن</button></noscript>
      <span id="liveIndicator" class="btn btn-outline-secondary btn-sm btn-loading d-none" aria-live="polite">
        <span class="spinner-border" role="status" aria-hidden="true"></span>
        ئابدەیت کرن...
      </span>
    </div>
  </form>

  <?php if ($totalRows === 0): ?>
    <div class="alert alert-info">چ مولک نە هاتنە دیتن.</div>
  <?php else: ?>
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div class="text-muted small">
        <?=
          $showAll
            ? "Showing all {$totalRows} results"
            : ($totalRows ? (($offset+1) . '–' . min($offset+($perPage??$totalRows), $totalRows) . " of {$totalRows}") : "0 of 0")
        ?>
      </div>

      <?php if (!$showAll && $totalPages > 1): ?>
        <?php
  $baseQS = qs_keep(['q','type','pstatus','avail','area','size_min','size_max','price_min','price_max','year_min','year_max','sort','per_page']);
  $mk = fn($p) => '?'.$baseQS.'&page='.$p;
?>

<div class="d-flex justify-content-between align-items-center mb-2">
  <div class="text-muted small">
    <?=
      $showAll
        ? "Showing all {$totalRows} results"
        : ($totalRows ? (($offset+1) . '–' . min($offset+($perPage??$totalRows), $totalRows) . " of {$totalRows}") : "0 of 0")
    ?>
  </div>

  <?php if (!$showAll): ?>
    <?= render_pager($page, $totalPages, $mk) ?>
  <?php endif; ?>
</div>

        <nav aria-label="Pagination">
          <ul class="pagination pagination-sm mb-0">
            <?php
              $baseQS = qs_keep(['q','type','pstatus','avail','area','size_min','size_max','price_min','price_max','year_min','year_max','sort','per_page']);
              $mk = fn($p) => '?'.$baseQS.'&page='.$p;
            ?>
            <li class="page-item <?= $page<=1?'disabled':'' ?>">
              <a class="page-link" href="<?= $page<=1?'#':$mk($page-1) ?>" aria-label="Previous">&laquo;</a>
            </li>
            <?php
              $start = max(1, $page-2);
              $end   = min($totalPages, $page+2);
              if ($start > 1) {
                echo '<li class="page-item"><a class="page-link" href="'. $mk(1) .'">1</a></li>';
                if ($start > 2) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
              }
              for ($p=$start; $p<=$end; $p++) {
                $active = $p===$page ? 'active' : '';
                echo '<li class="page-item '.$active.'"><a class="page-link" href="'. $mk($p) .'">'.$p.'</a></li>';
              }
              if ($end < $totalPages) {
                if ($end < $totalPages-1) echo '<li class="page-item disabled"><span class="page-link">…</span></li>';
                echo '<li class="page-item"><a class="page-link" href="'. $mk($totalPages) .'">'.$totalPages.'</a></li>';
              }
            ?>
            <li class="page-item <?= $page>=$totalPages?'disabled':'' ?>">
              <a class="page-link" href="<?= $page>=$totalPages?'#':$mk($page+1) ?>" aria-label="Next">&raquo;</a>
            </li>
          </ul>
        </nav>
      <?php endif; ?>
    </div>

    <div class="row">
      <?php foreach ($rows as $p): ?>
        <div class="col-md-6 col-lg-4 mb-4">
          <div class="card card-property h-100 shadow-sm">
            <div class="card-body">
              <div class="d-flex align-items-start justify-content-between">
                <div>
                  <h5 class="card-title mb-1"><?= htmlspecialchars($p['title'] ?: ('#'.$p['code'])) ?></h5>
                  <div class="text-muted small">Code: <?= htmlspecialchars($p['code']) ?></div>
                </div>
                <span class="badge <?= htmlspecialchars(badgeClass($p['property_type'], $typeClasses)) ?> badge-type">
                  <?= htmlspecialchars($p['property_type']) ?>
                </span>
              </div>

              <div class="mt-3 small">
                <div class="text-muted">Area & Size</div>
                <div><strong><?= htmlspecialchars($p['area'] ?: '—') ?></strong> ·
                  <?= $p['size_sqft'] !== null && $p['size_sqft'] !== '' ? number_format((float)$p['size_sqft']) : '—' ?> sqft
                </div>
              </div>

              <div class="mt-2 small">
                <div class="text-muted">Price</div>
                <div><strong><?= $p['price'] !== null ? number_format((float)$p['price'], 2) : '—' ?></strong></div>
              </div>

              <div class="mt-2 d-flex flex-wrap gap-2">
                <span class="badge bg-light text-dark border"><?= htmlspecialchars($p['property_status'] ?: '—') ?></span>
                <span class="badge <?= htmlspecialchars(badgeClass($p['status'], $availClasses)) ?>"><?= htmlspecialchars($p['status'] ?: '—') ?></span>
                <?php if (!empty($p['year_built'])): ?>
                  <span class="badge bg-secondary-subtle text-dark border">Year: <?= (int)$p['year_built'] ?></span>
                <?php endif; ?>
              </div>

              <a href="../property-details.php?id=<?= (int)$p['id'] ?>" class="stretched-link" aria-label="Open property details"></a>
            </div>
            <div class="card-footer text-muted small">
              Added on <?= date('Y-m-d H:i', strtotime($p['created_at'])) ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
<script>
// Live apply: instant on selects/sort/per_page; text/number/search submit on Enter or when focus leaves (no mid-typing submits)
(function(){
  const form = document.getElementById('filtersForm');
  const indicator = document.getElementById('liveIndicator');
  if (!form) return;

  const submitNow = () => {
    // Always reset to page=1 on filter/sort changes
    let pageInput = form.querySelector('input[name="page"]');
    if (!pageInput) {
      pageInput = document.createElement('input');
      pageInput.type = 'hidden';
      pageInput.name = 'page';
      form.appendChild(pageInput);
    }
    pageInput.value = '1';
    indicator?.classList.remove('d-none');
    form.submit();
  };

  form.querySelectorAll('.js-auto').forEach(el => {
    const instant = el.dataset.submit === 'instant';
    const isTextLike = ['text','number','search'].includes(el.type);

    if (instant) {
      // selects / sort / per_page -> submit immediately on change
      el.addEventListener('change', submitNow);
      return;
    }

    if (isTextLike) {
      // Submit ONLY when user hits Enter...
      el.addEventListener('keydown', (e) => {
        if (e.key === 'Enter') {
          e.preventDefault();
          submitNow();
        }
      });
      // ...or when they finish and leave the field
      el.addEventListener('change', submitNow); // fires on blur if value changed
      el.addEventListener('blur', () => {
        // optional: if value changed while typing but no Enter pressed, blur still submits
        // (change above already covers this in most browsers; blur is a safety net)
        // submitNow();
      });
      // IMPORTANT: do NOT submit on 'input' (prevents mid-typing submits)
      return;
    }

    // Fallback: non-text inputs default to change
    el.addEventListener('change', submitNow);
  });
})();
</script>


<?php require_once "../includes/footer.php"; ?>
