
<?php

require_once "../../functions/database.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['property_id'])) {
    die("Invalid request.");
}

$propertyId = (int)$_POST['property_id'];
try {
    $pdo = new PDO("mysql:host=localhost;dbname=homeland;charset=utf8mb4", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("DB connection failed: " . $e->getMessage());
}

function sanitize($val) {
    return htmlspecialchars(trim($val));
}

// Check property ID
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['property_id'])) {
    die("Invalid request.");
}

$id = (int)$_POST['property_id'];

// Common fields
$data = [
    'title' => sanitize($_POST['title'] ?? ''),
    'description' => sanitize($_POST['description'] ?? ''),
    'property_type' => $_POST['property_type'] ?? '',
    'owner_name' => sanitize($_POST['owner_name'] ?? ''),
    'owner_phone' => sanitize($_POST['owner_phone'] ?? ''),
    'price' => $_POST['price'] ?? null,
    'size_sqft' => $_POST['size'] ?? null,
    'directions' => sanitize($_POST['direction'] ?? ''),
    'property_status' => $_POST['property_status'] ?? '',
    'updated_at' => date('Y-m-d H:i:s')
];

// Additional based on type
$type = $data['property_type'];

if ($type === 'house') {
    $data += [
        'area' => $_POST['area'] ?? null,
        'street_address' => sanitize($_POST['street'] ?? ''),
        'unit' => sanitize($_POST['unit'] ?? ''),
        'year_built' => $_POST['year'] ?? null,
        'house_number' => sanitize($_POST['house_number'] ?? ''),
        'note' => sanitize($_POST['note'] ?? ''),
    ];
} elseif ($type === 'land') {
    $data += [
        'area' => $_POST['area'] ?? null,
        'street_address' => sanitize($_POST['street'] ?? ''),
        'land_number' => sanitize($_POST['land_number'] ?? '')
    ];
} elseif ($type === 'Apartment (Installment)') {
    $data += [
        'residence_name' => sanitize($_POST['residence'] ?? ''),
        'floor' => $_POST['floor'] ?? null,
        'tower_number' => sanitize($_POST['tower'] ?? ''),
        'money_paid' => $_POST['paid'] ?? null,
        'monthly_installment' => $_POST['monthly'] ?? null,
        'remain_amount' => $_POST['remaining'] ?? null,
        'total_price' => $_POST['total'] ?? null
    ];
} elseif ($type === 'Apartment (cash)') {
    $data += [
        'residence_name' => sanitize($_POST['residence'] ?? ''),
        'tower_number' => sanitize($_POST['tower'] ?? '')
    ];
}

// Create dynamic SQL query
$setParts = [];
foreach ($data as $key => $value) {
    $setParts[] = "`$key` = :$key";
}

$sql = "UPDATE properties SET " . implode(', ', $setParts) . " WHERE id = :id";
$stmt = $pdo->prepare($sql);

// Add ID to bind parameters
$data['id'] = $id;

try {
    $stmt->execute($data);
    header("Location: edit-property.php?id=$id&updated=1");
    exit;
} catch (PDOException $e) {
    die("Failed to update property: " . $e->getMessage());
}
?>
