<?php require_once "includes/header.php"; ?>
<?php require_once "../functions/database.php"; ?>

<?php
if (!isset($_GET['id'])) {
  header("Location: 404.php");
  exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_sold'])) {
    $stmt = $pdo->prepare("UPDATE properties SET status = 'Sold' WHERE id = ?");
    $stmt->execute([(int)$_POST['property_id']]);
    header("Location: property-details.php?id=" . (int)$_POST['property_id']);
    exit;
}

$propertyID = (int) $_GET['id'];
$property = getPropertyByID($propertyID);
if (!$property) {
  header("Location: 404.php");
  exit;
}
$galleries = getPropertyGallery($propertyID);
$related = getRelatedProperties($property['property_type'], $property['area'], $propertyID);
$isLoggedIn = isset($_SESSION['user']);
$user = $isLoggedIn ? $_SESSION['user'] : null;
$alreadyRequested = $isLoggedIn ? inRequests($user['id'], $propertyID) : false;
$alreadyFavorite = $isLoggedIn ? inFavorites($user['id'], $propertyID) : false;
?>

<!-- Gallery styling -->
<style>
  .gallery-thumb {
    width: 100%;
    height: 180px;
    object-fit: cover;
    border-radius: 6px;
    cursor: pointer;
    transition: 0.3s;
  }

  .gallery-thumb:hover {
    transform: scale(1.03);
  }
</style>

<!-- Header -->
<div class="position-relative"
  style="background:url('assets/uploads/properties/galleries/<?= htmlspecialchars($property['image']) ?>') center/cover; height:320px;">
  <div
    class="position-absolute top-0 mt-4 start-0 w-100 h-100 bg-dark bg-opacity-50 d-flex flex-column justify-content-center align-items-center text-white">
    <h1><?= htmlspecialchars($property['street_address']) ?></h1>
    <p class="h4 text-success">$<?= number_format($property['price']) ?></p>
  </div>
</div>

<main class="container py-5" style="margin-top: 30px !important;">
  <div class="row">
    <!-- Left Column -->
    <div class="col-lg-8">
      <!-- Gallery -->
      <h4 class="mb-3">وێنە</h4>
      <?php if ($galleries): ?>
        <div class="row g-3 mb-4">
          <?php foreach ($galleries as $i => $g): ?>
            <div class="col-6 col-sm-4 col-md-3">
              <img src="<?= URL('assets/uploads/properties/galleries/' . htmlspecialchars($g['image_url'])) ?>"
                class="gallery-thumb" data-bs-toggle="modal" data-bs-target="#galleryModal" data-index="<?= $i ?>">
            </div>
          <?php endforeach; ?>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="galleryModal" tabindex="-1">
          <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content bg-dark">
              <button type="button" class="btn-close btn-close-white p-3 position-absolute top-0 end-0"
                data-bs-dismiss="modal"></button>
              <img id="modal-image" class="w-100" style="max-height:90vh; object-fit:contain;">
              <button id="prev-image"
                class="btn btn-light position-absolute top-50 start-0 translate-middle-y ms-2">&#10094;</button>
              <button id="next-image"
                class="btn btn-light position-absolute top-50 end-0 translate-middle-y me-2">&#10095;</button>
            </div>
          </div>
        </div>
        <script>
          const galleryImages = <?= json_encode(array_column($galleries, 'image_url')) ?>;
          let currentIndex = 0;
          document.querySelectorAll('.gallery-thumb').forEach((img, idx) =>
            img.addEventListener('click', () => {
              currentIndex = idx;
              document.getElementById('modal-image').src = "assets/uploads/properties/galleries/" + galleryImages[idx];
            })
          );
          document.getElementById('prev-image').onclick = () => {
            currentIndex = (currentIndex + galleryImages.length - 1) % galleryImages.length;
            document.getElementById('modal-image').src = "assets/uploads/properties/galleries/" + galleryImages[currentIndex];
          };
          document.getElementById('next-image').onclick = () => {
            currentIndex = (currentIndex + 1) % galleryImages.length;
            document.getElementById('modal-image').src = "assets/uploads/properties/galleries/" + galleryImages[currentIndex];
          };
        </script>
      <?php else: ?>
        <div class="alert alert-warning">هیچ وێنە بەردەست نینە</div>
      <?php endif; ?>

      <!-- Details -->
      <div class="bg-white p-4 rounded shadow-sm">
        <div style="display:flex">
          <h4>Code: </h4>
          <h4><?= nl2br(htmlspecialchars($property['code'])) ?></h4>
        </div>

        <h4><?= nl2br(htmlspecialchars($property['title'])) ?></h4>
        <p><?= nl2br(htmlspecialchars($property['description'])) ?></p>
        <div class="row mt-3">
          <?php foreach (['جورێ مولکی' => $property['property_type'], 'روبەر' => $property['size_sqft'] . ' m', 'تابق' => $property['unit'], 'سالا ئاڤاکرنێ' => $property['year_built'], 'بەردەستە' => $property['status'], 'مەنتەقە' => $property['area']] as $label => $val): ?>
            <div class="col-sm-6 mb-2"><strong><?= $label ?>:</strong> <?= htmlspecialchars($val) ?></div>
          <?php endforeach; ?>
        </div>
        <h5 class="mt-4">ژمارا ژورا</h5>
        <p><?= nl2br(htmlspecialchars($property['rooms'])) ?></p>
      </div>
    </div>

    <!-- Right Column -->
    <div class="col-lg-4">
      <div class="col-sm-6 mb-2">
  <strong>بەردەستە/فروتیە:</strong>
  <?php if ($property['status'] === 'Available'): ?>
    <span class="badge bg-success">Available</span>
  <?php else: ?>
    <span class="badge bg-danger">Sold</span>
  <?php endif; ?>
</div>


      <div class="bg-white p-4 rounded shadow-sm mb-4 border border-light">
        <h5 class="mb-3 text-primary"><i class="bi bi-person-circle me-2"></i>زانیاری یێن خودانی</h5>

        <button id="toggle-owner-btn" class="btn btn-outline-dark w-100 mb-3" type="button"
          onclick="toggleOwnerDetails()">
          <i class="bi bi-eye me-1"></i> زانیاریا دیاربکە
        </button>

        <div id="owner-details" class="d-none border-top pt-3">
          <div class="mb-2">
            <i class="bi bi-person-fill text-secondary me-2"></i>
            <strong>ناڤ:</strong> <?= htmlspecialchars($property['owner_name']) ?>
          </div>
          <div>
            <i class="bi bi-telephone-fill text-secondary me-2"></i>
            <strong>ژمارە:</strong> <?= htmlspecialchars($property['owner_phone']) ?>
          </div>
        </div>
      </div>
    </div>

    <!-- Bootstrap Icons (if not already included) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <!-- Toggle Script -->
    <script>
      function toggleOwnerDetails() {
        const details = document.getElementById('owner-details');
        const button = document.getElementById('toggle-owner-btn');
        const icon = button.querySelector('i');

        details.classList.toggle('d-none');

        if (details.classList.contains('d-none')) {
          button.innerHTML = '<i class="bi bi-eye me-1"></i> زانیاریا دیاربکە';
        } else {
          button.innerHTML = '<i class="bi bi-eye-slash me-1"></i> ڤەشارتنا زانیاریا';
        }
      }
    </script>

  </div>

  <!-- Related Properties -->
  <?php if ($related): ?>
    <hr class="my-5">
    <h4>Related Properties</h4>
    <div class="row mt-3">
      <?php foreach ($related as $rel): ?>
        <?php
        $img = getPropertyGallery($rel['id'])[0]['image_url'] ?? 'no-image.jpg';
        ?>
        <div class="col-md-6 col-lg-4 mb-4">
          <div class="card h-100">
            <img src="<?= URL('assets/uploads/properties/galleries/' . htmlspecialchars($img)) ?>" class="card-img-top"
              style="height:180px;object-fit:cover;">
            <div class="card-body d-flex flex-column">
              <h6 class="card-title"><?= htmlspecialchars($rel['street_address']) ?></h6>
              <p class="mt-auto text-success">$<?= number_format($rel['price']) ?></p>
              <a href="<?= URL('property-details.php?id=' . $rel['id']) ?>"
                class="btn btn-sm btn-outline-primary mt-2">View</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</main>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php require_once "includes/footer.php"; ?>