<?php require_once "../includes/header.php"; ?>
<?php require_once "../../functions/database.php"; ?>

<style>
.card-request {
    transition: transform .08s ease-in-out, box-shadow .1s ease-in-out;
    border-radius: .75rem;
}
.card-request:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 18px rgba(0,0,0,.08);
}
.card-request .badge-type { text-transform: capitalize; }
</style>

<div class="container mt-5 pt-5">
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h2 class="mb-0">Client Requests</h2>
    </div>

    <?php
    // Pull newest first
    $stmt = $pdo->query("SELECT id, client_name, client_phone, property_type, note, area, size_meters, created_at
                         FROM client_requests
                         ORDER BY created_at DESC");
    $requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>

    <?php if (empty($requests)): ?>
        <div class="alert alert-info">No client requests found.</div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($requests as $req): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card card-request h-100 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-start justify-content-between">
                                <div>
                                    <h5 class="card-title mb-1">
                                        <?= htmlspecialchars($req['client_name']) ?>
                                    </h5>
                                    <div class="text-muted small"><?= htmlspecialchars($req['client_phone']) ?></div>
                                </div>
                                <span class="badge bg-primary-subtle text-primary border border-primary-subtle badge-type">
                                    <?= htmlspecialchars(str_replace('_',' ', $req['property_type'])) ?>
                                </span>
                            </div>

                            <div class="mt-3">
                                <div class="small text-muted">Area & Size</div>
                                <div><strong><?= htmlspecialchars($req['area'] ?: '—') ?></strong> &middot; <?= htmlspecialchars($req['size_meters'] ?: '—') ?> m²</div>
                            </div>

                            <?php if (!empty($req['note'])): ?>
                                <p class="mt-3 mb-0 text-truncate-2" style="-webkit-line-clamp:2;display:-webkit-box;-webkit-box-orient:vertical;overflow:hidden;">
                                    <?= nl2br(htmlspecialchars($req['note'])) ?>
                                </p>
                            <?php endif; ?>

                            <a href="request-details.php?id=<?= (int)$req['id'] ?>" class="stretched-link" aria-label="Open request details"></a>
                        </div>
                        <div class="card-footer text-muted small">
                            Submitted on <?= date('Y-m-d H:i', strtotime($req['created_at'])) ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php require_once "../includes/footer.php"; ?>
